<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php bloginfo('name'); ?> | <?php is_front_page() ? bloginfo('description') : wp_title(''); ?></title>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<!-- Header -->
	<header id="header">
		<div class="container header-container">
			<a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
				<?php
				if (has_custom_logo()) {
					the_custom_logo();
				} else {
					echo 'Parawangsa<span>Persada</span>';
				}
				?>
			</a>
			<div class="mobile-menu-btn">
				<i class="fas fa-bars"></i>
			</div>
			<nav id="nav">
				<?php
				wp_nav_menu(array(
					'theme_location' => 'primary',
					'container' => false,
					'items_wrap' => '<ul>%3$s</ul>',
				));
				?>
			</nav>
		</div>
	</header>